#pragma once

class CShader
{
private:
	UINT uiShader;
	int iType;
	bool bLoaded;

public:
	CShader();

	UINT getShaderID();

	bool loadShader(string sFile, int a_iType);
	void deleteShader();
	bool isLoaded();
};

class CShaderProgram
{
private:
	UINT uiProgram;
	bool bLinked;

public:
	CShaderProgram();

	UINT getProgramID();

	void createProgram();
	void deleteProgram();
	bool addShaderToProgram(CShader* shShader);
	bool linkProgram();
	void useProgram();
	void setUniform(string sName, vec2* vVectors, int iCount = 1);
	void setUniform(string sName, const vec2 vVector);
	void setUniform(string sName, vec3* vVectors, int iCount = 1);
	void setUniform(string sName, const vec3 vVector);
	void setUniform(string sName, vec4* vVectors, int iCount = 1);
	void setUniform(string sName, const vec4 vVector);
	void setUniform(string sName, float* fValues, int iCount = 1);
	void setUniform(string sName, const float fValue);
	void setUniform(string sName, mat3* mMatrices, int iCount = 1);
	void setUniform(string sName, const mat3 mMatrix);
	void setUniform(string sName, mat4* mMatrices, int iCount = 1);
	void setUniform(string sName, const mat4 mMatrix);
	void setUniform(string sName, int* iValues, int iCount = 1);
	void setUniform(string sName, const int iValue);
};
